<?php
/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 * Github: https://github.com/kivancagaogluu/
 *
 */

require_once __DIR__ . '/functions.php';

error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);

if($_POST) {

    $title = $_POST['title'];

    $spintax = $_POST['spintax'];

    $file = $_POST['file'];

    $url = rtrim($_POST['url'], '/') . '/api/post.php';

    $image = $_POST['image'];

    $reportDate = $_POST['report_date'];

    $content = file_get_contents($file);

//  $content = preg_replace('@<style.*?</style>@si', '', $content);


    $content = strip_tags($content, '<p><a><img><img><ul><ol><li><strong><em><b><i><u><br><h1><h2><h3><h4><h5><h6><button><hr><i><div><iframe><style>');

    if($image){
        $imageBase64 = base64_encode(file_get_contents(__DIR__ . '/tmp/' . $image));
    }

    $request = curlPost($url, [
        'title' => $title,
        'spintax' => $spintax,
        'content' => $content,
        'image' => $imageBase64,
    ]);

    $request = json_decode($request);

    if($request->status == 'success') {
        if(!file_exists(__DIR__ . '/reports/' . $reportDate . '.json')) {
            file_put_contents(__DIR__ . '/reports/' . $reportDate . '.json', json_encode([
                [
                    'title' => $title,
                    'spintax' => $spintax,
                    'post_url' => $request->post_url,
                    'created_at' => date('Y-m-d H:i:s'),
                ]
            ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
        }else{
            $reports = json_decode(file_get_contents(__DIR__ . '/reports/' . $reportDate . '.json'));
            $reports[] = [
                'title' => $title,
                'spintax' => $spintax,
                'post_url' => $request->post_url,
                'created_at' => date('Y-m-d H:i:s'),
            ];
            file_put_contents(__DIR__ . '/reports/' . $reportDate . '.json', json_encode($reports, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
        }
        $response = [
            'status' => 'success',
            'message' => 'Post created successfully.',
            'post_url' => $request->post_url,
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Post could not be created.',
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;

}