<?php

/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 *
 */

require_once __DIR__ . '/functions.php';

$posts = json_decode(curl($postsUrl));

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.5.1.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"
            integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo"
            crossorigin="anonymous"></script>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
          integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"
            integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
            crossorigin="anonymous"></script>

    <title>Multi Article</title>
</head>
<body>

<script>
    $(document).ready(function () {
        $('button[name="submit"]').on('click', function () {
            $.ajax({
                url: 'index.php',
                type: 'POST',
                data: new FormData($('form')[0]),
                processData: false,
                contentType: false,
                success: function (response) {
                    $('tbody').html('');
                    if (response.status === 'success') {
                        response.data.postList.forEach(function (post) {
                            $('tbody').append(`
                                <tr>
                                    <td>${post.url}</td>
                                    <td>${post.title}</td>
                                    <td>${post.image}</td>
                                    <td>
                                    <form method="post" action="sender.php">
                                        <input type="hidden" name="spintax" value="${response.data.spintax}">
                                        <input type="hidden" name="file" value="${post.file}">
                                        <input type="hidden" name="url" value="${post.url}">
                                        <input type="hidden" name="title" value="${post.title}">
                                        <input type="hidden" name="image" value="${post.image}">
                                        <input type="hidden" name="report_date" value="${response.data.report_date}">
                                        <button type="button" class="btn btn-primary post-data">
                                            Gönder
                                        </button>
                                    </td>
                                </tr>
                            `);
                        });
                        $('.post-data').on('click', function () {
                            let button = $(this);
                            button.attr('disabled', true);
                            button.html('Gönderiliyor...');
                            var form = $(this).parent('form')[0];
                            $.ajax({
                                url: 'sender.php',
                                type: 'POST',
                                data: new FormData(form),
                                processData: false,
                                contentType: false,
                                success: function (response) {
                                    if (response.status === 'success') {
                                        button.html('Gönderildi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-success');
                                        button.removeClass('post-data');
                                    } else {
                                        button.html('Gönderilemedi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-danger');
                                    }
                                }
                            });
                        });
                        let delay = 0;
                        $('#submit_all').on('click', function () {
                            $('.post-data').each(function () {
                                let button = $(this);
                                setTimeout(function () {
                                    button.click();
                                }, delay);
                                delay += 1000;
                            });
                        });
                    }
                }
            });
        });

    })
</script>

<div class="container" align="center">

    <hr>
    <hr>
    <h4><a href="index.php">Makale Oluşturucu</a> | <a href="reports.php">Raporlar</a> | <a href="posts.php">Postlar</a></h4>
    <hr>
    <hr>

    <button type="button" class="btn btn-success mb-3" id="download_all">Hepsini İndir</button>

    <table class="table table-hover table-striped">
        <thead>
        <tr>
            <th>Başlık</th>
            <th>Link</th>
            <th>İşlem</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($posts as $post): ?>
            <tr>
                <td><?= $post->post_title ?></td>
                <td><a href="<?= $post->guid ?>" target="_blank"><?= $post->guid ?></a>
                <td>
                    <button type="button" class="btn btn-primary download_content" data-url="<?= $post->guid ?>">
                        İndir
                    </button>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

</div>

<script>

    $(document).ready(function () {

        $('.download_content').click(function () {

            let button = $(this);
            button.attr('disabled', true);
            button.html('İndiriliyor...');
            let url = button.data('url');
            $.ajax({
                url: 'download.php',
                type: 'POST',
                data: {url: url},
                success: function (response) {
                    if (response.status === 'success') {
                        button.html('İndirildi');
                        button.attr('disabled', true);
                        button.removeClass('btn-primary');
                        button.addClass('btn-success');
                        button.removeClass('download_content');
                    } else {
                        button.html('İndirilemedi');
                        button.attr('disabled', true);
                        button.removeClass('btn-primary');
                        button.removeClass('download_content');
                        button.addClass('btn-danger');
                    }
                }
            });

        })

        let timeStart   = 0;
        let between     = 1000;

        $('#download_all').click(function (key, value) {

            $.each($('.download_content'), function(key, value) {
                setTimeout(function() {
                    $(value).trigger('click')
                }, timeStart);
                timeStart = timeStart + between;
            });

        });

    });

</script>

</body>
</html>