<?php

/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 *
 */

require_once __DIR__ . '/functions.php';

if ($_POST) {

    deleteTemporaryFiles();

    $reportId = uniqid('report');

    $preContent = $_POST['pre_content'];

    $afterContent = $_POST['after_content'];

    $htmlFiles = $_FILES['html_files'];

    $imageFiles = $_FILES['image_files'];

    $spintax = $_POST['spintax'];

    $articleUseCount = $_POST['article_use_count'] ?? 1;

    $imageUseCount = $_POST['image_use_count'] ?? 1;

    $urls = explode(PHP_EOL, $_POST['urls']);

    $count = 1;

    foreach ($htmlFiles['name'] as $key => $htmlFile) {

        $htmlFileContent = file_get_contents($htmlFiles['tmp_name'][$key]);

        $htmlFileContent = $preContent . $htmlFileContent . $afterContent;

        $htmlFileTmpName = $htmlFiles['tmp_name'][$key];

        $htmlFileExtension = pathinfo($htmlFile, PATHINFO_EXTENSION);

        $htmlFileName = pathinfo($htmlFile, PATHINFO_FILENAME);

        $htmlFileNewName = $count . '__' . $htmlFileName . '.' . $htmlFileExtension;

        $htmlFileNewPath = __DIR__ . '/tmp/' . $htmlFileNewName;

        file_put_contents($htmlFileNewPath, $htmlFileContent);

        chmod($htmlFileNewPath, 0777);

//        move_uploaded_file($htmlFileTmpName, $htmlFileNewPath);

        $count++;

    }

    if ($imageFiles) {

        $count = 1;

        foreach ($imageFiles['name'] as $key => $imageFile) {

            $imageFileTmpName = $imageFiles['tmp_name'][$key];

            $imageFileExtension = pathinfo($imageFile, PATHINFO_EXTENSION);

            $imageFileName = pathinfo($imageFile, PATHINFO_FILENAME);

            $imageFileNewName = $count . '__' . $imageFileName . '.' . $imageFileExtension;

            $imageFileNewPath = __DIR__ . '/tmp/' . $imageFileNewName;

            move_uploaded_file($imageFileTmpName, $imageFileNewPath);

            $count++;

        }

        $images = array_map(function ($file) {
            return [
                'name' => $file,
                'used' => 1
            ];
        }, glob(__DIR__ . '/tmp/*.{jpg,jpeg,png,gif,svg}', GLOB_BRACE));

    }

    $files = array_map(function ($file) {
        return [
            'name' => $file,
            'used' => 1
        ];
    }, glob(__DIR__ . '/tmp/*.html'));
    

    $postList = [];

    foreach ($files as $file) {

        while ($file['used'] <= $articleUseCount) {

            $file['used']++;

            $title = explode('.', explode('__', basename($file['name']))[1]);
            
            unset($title[count($title)-1]);
            
            $title = implode('.', $title);

            $postList[] = [
                'file' => $file['name'],
                'url' => trim($urls[0]),
                'title' => $title,
                'image' => basename($images[0]['name']),
                'spintax' => $spintax,
                'report_id' => $reportId
            ];

            $images[0]['used']++;

            if ($images[0]['used'] > $imageUseCount) {
                unset($images[0]);
                $images = array_values($images);
            }

            unset($urls[0]);

            $urls = array_values($urls);

            if (!$urls) {
                break;
            }

        }

        if (!$urls) {
            break;
        }

    }

    $response = [
        'status' => 'success',
        'message' => 'Dosyalar başarıyla yüklendi.',
        'data' => [
            'postList' => $postList,
            'spintax' => $spintax,
            'report_date' => date('d.m.Y H:i:s'),
        ]
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;

}

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.5.1.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"
            integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo"
            crossorigin="anonymous"></script>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
          integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"
            integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
            crossorigin="anonymous"></script>

    <title>Multi Article</title>
</head>
<body>

<script>
    $(document).ready(function () {
        $('button[name="submit"]').on('click', function () {
            $.ajax({
                url: 'index.php',
                type: 'POST',
                data: new FormData($('form')[0]),
                processData: false,
                contentType: false,
                success: function (response) {
                    $('tbody').html('');
                    if (response.status === 'success') {
                        response.data.postList.forEach(function (post) {
                            $('tbody').append(`
                                <tr>
                                    <td>${post.url}</td>
                                    <td>${post.title}</td>
                                    <td>${post.image}</td>
                                    <td>
                                    <form method="post" action="sender.php">
                                        <input type="hidden" name="spintax" value="${response.data.spintax}">
                                        <input type="hidden" name="file" value="${post.file}">
                                        <input type="hidden" name="url" value="${post.url}">
                                        <input type="hidden" name="title" value="${post.title}">
                                        <input type="hidden" name="image" value="${post.image}">
                                        <input type="hidden" name="report_date" value="${response.data.report_date}">
                                        <button type="button" class="btn btn-primary post-data">
                                            Gönder
                                        </button>
                                    </td>
                                </tr>
                            `);
                        });
                        $('.post-data').on('click', function () {
                            let button = $(this);
                            button.attr('disabled', true);
                            button.html('Gönderiliyor...');
                            var form = $(this).parent('form')[0];
                            $.ajax({
                                url: 'sender.php',
                                type: 'POST',
                                data: new FormData(form),
                                processData: false,
                                contentType: false,
                                success: function (response) {
                                    if (response.status === 'success') {
                                        button.html('Gönderildi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-success');
                                        button.removeClass('post-data');
                                    } else {
                                        button.html('Gönderilemedi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-danger');
                                    }
                                }
                            });
                        });
                        let delay = 0;
                        $('#submit_all').on('click', function () {
                            $('.post-data').each(function () {
                                let button  = $(this);
                                setTimeout(function () {
                                    button.click();
                                }, delay);
                                delay += 1000;
                            });
                        });
                    }
                }
            });
        });

    })
</script>

<div class="container" align="center">

    <hr>
    <hr>
    <h4>Makale Oluşturucu | <a href="reports.php">Raporlar</a> | <a href="posts.php">Postlar</a></h4>
    <hr>
    <hr>

    <form action="" id="file_form" enctype="multipart/form-data">

        <div class="form-group col-6">
            <label><strong>Üst HTML</strong></label>
            <textarea name="pre_content" class="form-control" cols="30" rows="2"></textarea>
        </div>

        <div class="form-group col-6">
            <label><strong>HTML Dosyalar</strong></label>
            <input type="file" name="html_files[]" class="form-control" accept="text/html" placeholder="HTML Dosyalar"
                   multiple>
        </div>

        <div class="form-group col-6">
            <label><strong>Alt HTML</strong></label>
            <textarea name="after_content" class="form-control" cols="30" rows="2"></textarea>
        </div>

        <div class="form-group col-6">
            <label><strong>Görsel Dosyalar</strong></label>
            <input type="file" name="image_files[]" class="form-control" accept="image" placeholder="Görsel Dosyalar"
                   multiple>
        </div>

        <div class="form-group col-6">
            <label><strong>Makale Kullanım Adedi</strong> <em>Her bir makale girilen değer kadar
                    kullanılacak</em></label>
            <input type="text" name="article_use_count" class="form-control" placeholder="">
        </div>

        <div class="form-group col-6">
            <label><strong>Görsel Kullanım Adedi</strong></label>
            <input type="text" name="image_use_count" class="form-control" placeholder="">
        </div>

        <div class="form-group form-check col-6">
            <input type="checkbox" id="spintax" name="spintax" value="1" class="form-check-input" placeholder="">
            <label class="form-check-label" for="spintax"><strong>Spintax</strong></label>
        </div>

        <div class="form-group col-6">
            <label><strong>Site Adresleri</strong> <em>Sonunda slash karakteri bulunmamalı ve alt alta
                    yazılmalı</em></label>
            <textarea name="urls" class="form-control" cols="30" rows="10"></textarea>
        </div>

        <button type="button" class="btn btn-info" name="submit" value="1">Ekle</button>
    </form>

    <table class="table table-striped table-hover text-center m-3">
        <thead>
        <tr>
            <th>Adres</th>
            <th>Başlık</th>
            <th>Görsel</th>
            <th>
                <button type="button" id="submit_all" class="btn btn-primary">Tümünü Ekle</button>
            </th>
        </tr>
        </thead>
        <tbody>

        </tbody>
    </table>

    <hr>
    <hr>

</div>

</body>
</html>