<?php

/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 *
 */

require_once __DIR__ . '/functions.php';

//{a|b|c} {aa|bb|cc}

if ($_POST) {

    $titles = explode('|', rtrim(ltrim($_POST['titles'], '{'), '}'));

    $contents = explode('|', rtrim(ltrim($_POST['contents'], '{'), '}'));

    $beforeHtml = explode('|', rtrim(ltrim($_POST['before_html'], '{'), '}'));

    $afterHtml = explode('|', rtrim(ltrim($_POST['after_html'], '{'), '}'));

    $urls = explode(PHP_EOL, trim($_POST['urls']));

    $postList = [];

    foreach ($urls as $url) {

        $randomTitleKey = array_rand($titles);

        $randomContentKey = array_rand($contents);

        $randomBeforeHtmlKey = array_rand($beforeHtml);

        $randomAfterHtmlKey = array_rand($afterHtml);

        $postList[] = [
            'title' => $titles[$randomTitleKey],
            'content' => htmlspecialchars($beforeHtml[$randomBeforeHtmlKey] . '<br>' . $contents[$randomContentKey] . '<br>' . $afterHtml[$randomAfterHtmlKey]),
            'url' => trim($url),
        ];

    }

    $response = [
        'status' => 'success',
        'message' => 'Gönderime hazır',
        'data' => [
            'postList' => $postList,
            'report_date' => date('d.m.Y H:i:s'),
        ]
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;

}

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.5.1.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"
            integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo"
            crossorigin="anonymous"></script>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
          integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"
            integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
            crossorigin="anonymous"></script>

    <title>Multi Article</title>
</head>
<body>

<script>
    $(document).ready(function () {
        $('button[name="submit"]').on('click', function () {

            $('#posts_tbody').html('');
            $('#posts_urls_tbody').html('');

            $.ajax({
                url: 'index.php',
                type: 'POST',
                data: new FormData($('form')[0]),
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response.status === 'success') {
                        response.data.postList.forEach(function (post) {
                            $('#posts_tbody').append(`
                                <tr>
                                    <td>${post.url}</td>
                                    <td>${post.title}</td>
                                    <td>${post.content}</td>
                                    <td>
                                    <form method="post" action="sender.php">
                                        <input type="hidden" name="title" value="${post.title}">
                                        <input type="hidden" name="content" value="${post.content}">
                                        <input type="hidden" name="url" value="${post.url}">
                                        <button type="button" class="btn btn-primary post-data">
                                            Gönder
                                        </button>
                                    </td>
                                </tr>
                            `);
                        });
                        $('.post-data').on('click', function () {
                            let button = $(this);
                            button.attr('disabled', true);
                            button.html('Gönderiliyor...');
                            var form = $(this).parent('form')[0];
                            $.ajax({
                                url: 'sender.php',
                                type: 'POST',
                                data: new FormData(form),
                                processData: false,
                                contentType: false,
                                success: function (response) {
                                    if (response.status === 'success') {
                                        button.html('Gönderildi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-success');
                                        button.removeClass('post-data');
                                        $('#posts_urls_tbody').append(`
                                            <tr>
                                                <td><a href="${response.post_url}" target="_blank">${response.post_url}</td>
                                            </tr>
                                        `);
                                    } else {
                                        button.html('Gönderilemedi');
                                        button.attr('disabled', true);
                                        button.removeClass('btn-primary');
                                        button.addClass('btn-danger');
                                    }
                                }
                            });
                        });
                        let delay = 0;
                        $('#submit_all').on('click', function () {
                            $('.post-data').each(function () {
                                let button = $(this);
                                setTimeout(function () {
                                    button.click();
                                }, delay);
                                delay += 1000;
                            });
                        });
                    }
                }
            });
        });

    })
</script>

<div class="container" align="center">

    <hr>
    <hr>
    <h4>Makale Oluşturucu | <a href="reports.php">Raporlar</a> | <a href="posts.php">Postlar</a></h4>
    <hr>
    <hr>

    <form action="" id="file_form" enctype="multipart/form-data">

        <div class="form-group col-6">
            <label><strong>Başlıklar</strong></label>
            <input type="text" name="titles" class="form-control" placeholder="" value="{a|b|c}">
        </div>

        <div class="form-group col-6">
            <label><strong>Html Öncesi</strong></label>
            <textarea name="before_html" class="form-control" cols="30" rows="10"></textarea>
        </div>

        <div class="form-group col-6">
            <label><strong>Html Sonrası</strong></label>
            <textarea name="after_html" class="form-control" cols="30" rows="10"></textarea>
        </div>

        <div class="form-group col-6">
            <label><strong>İçerikler</strong></label>
            <textarea name="contents" class="form-control" cols="30" rows="10">{aa|bb|cc}</textarea>
        </div>


        <div class="form-group col-6">
            <label><strong>Site Adresleri</strong> <em>Sonunda slash karakteri bulunmamalı ve alt alta
                    yazılmalı</em></label>
            <textarea name="urls" class="form-control" cols="30" rows="10"></textarea>
        </div>

        <button type="button" class="btn btn-info" name="submit" value="1">Ekle</button>
    </form>

    <table class="table table-striped table-hover text-center m-3" id="posts_table"
    <thead>
    <tr>
        <th>Adres</th>
        <th>Başlık</th>
        <th>İçerik</th>
        <th>
            <button type="button" id="submit_all" class="btn btn-primary">Tümünü Ekle</button>
        </th>
    </tr>
    </thead>
    <tbody id="posts_tbody">

    </tbody>
    </table>

    <hr>
    <hr>

    <table class="table table-striped table-hover text-center m-3" id="post_urls_table"
    <thead>
    <tr>
        <th>Link</th>
    </tr>
    </thead>
    <tbody id="posts_urls_tbody">

    </tbody>
    </table>

</div>

</body>
</html>